clear all; close all;

% Configurations
filename = 'sig.wav';
M = 26;
filterDB = [-40, 0];

% Initialization
[sig, fs] = wavread('sig.wav');

X = fft(sig);
Xmag = 20*log10(abs(X));

melfb = mel_filters(fs, M);
melindices = melfb*length(sig)/fs;



%
%
% Figure(1). Spectrum with Mel-Filterbank and Average Energy
%
%
figure();
subplot(2, 1, 1);
plot((1:length(sig)/2)/length(sig)*fs, Xmag(1:end/2));
hold on;
for ii = 1:size(melfb, 1)
    plot([melfb(ii, 1), mean(melfb(ii, :)), melfb(ii, 2)], [filterDB, filterDB(1)], 'k--');
end
hold off;

legend({'Spectrum', 'Mel-Filterbank'});
set(gca, 'fontsize', 20);
xlabel('frequency (Hz)', 'fontsize', 20);
ylabel('magnitude (db)', 'fontsize', 20);
title('Spectrum through Mel-Filterbank');


E = zeros(M, 1);
for ii = 1:size(melindices, 1)
    inds = [ceil(melindices(ii, 1)), floor(melindices(ii, 2))];
    inds = max(1, min(length(sig)/2, inds));
    inds = inds(1):inds(2);
    freqs = inds/length(sig)*fs;
    inds_l = find(inds <= mean(melindices(ii, :)));
    inds_r = find(inds >= mean(melindices(ii, :)));
    amp_l = power(10, lin_interpl( freqs(inds_l), melfb(ii, 1), mean(melfb(ii, :)), filterDB(1), filterDB(2) )/20);
    amp_r = power(10, lin_interpl( freqs(inds_r), mean(melfb(ii, :)), melfb(ii, 2), filterDB(2), filterDB(1) )/20);
    E(ii) = E(ii) + mean(amp_l .* abs(X(inds_l))');
    E(ii) = E(ii) + mean(amp_r .* abs(X(inds_r))');
end
clear inds freqs inds_l inds_r amp_l amp_r ii;

subplot(2, 1, 2);
stem(mean(melfb, 2), E);
set(gca, 'fontsize', 20);
xlabel('central frequency (Hz)', 'fontsize', 20);
ylabel('magnitude (1)', 'fontsize', 20);
title('Average Energy w.r.t. Central Frquency of Mel-Filterbank');

pause;

%
%
% Figure(2). Original/Truncated Cepstrum and corresponded vectors
%
%
C = dct(20*log10(E));
% figure();
subplot(2, 2, 1);
plot(20*log10(E));
set(gca, 'fontsize', 20);
xlabel('# of filters', 'fontsize', 20);
ylabel('magnitude (db)', 'fontsize', 20);
title('Average Energy w.r.t. Mel-Filterbank');

subplot(2, 2, 3);
plot(C);
set(gca, 'fontsize', 20);
xlabel('sample', 'fontsize', 20);
ylabel('magnitude', 'fontsize', 20);
title('Cepstrum of Average Energe');

C(7:end) = 0;
subplot(2, 2, 4);
plot(C);
set(gca, 'fontsize', 20);
xlabel('sample', 'fontsize', 20);
ylabel('magnitude', 'fontsize', 20);
title('Cepstrum of Average Energe');

subplot(2, 2, 2);
plot(idct(C));
set(gca, 'fontsize', 20);
xlabel('# of filters', 'fontsize', 20);
ylabel('magnitude (db)', 'fontsize', 20);
title('Average Energy w.r.t. Mel-Filterbank');


pause;
%
%
% Figure(3). Comparison between original/truncated in db
%
%
% figure();
subplot(1, 1, 1);
plot(1:M, 20*log10(E), 'b', 1:M, idct(C), 'r--');
legend({'Original', 'Envelope'});
set(gca, 'fontsize', 20);
xlabel('# of filters', 'fontsize', 20);
ylabel('magnitude (db)', 'fontsize', 20);
title('Average Energy w.r.t. Mel-Filterbank');

pause;
%
%
% Figure(4). Comparison between original/truncated in constant
%
%
% figure();
stem(mean(melfb, 2), E);
hold on;
plot(mean(melfb, 2), power(10, idct(C)/20), 'r--');
hold off;
legend({'Original', 'Envelope'});
set(gca, 'fontsize', 20);
xlabel('central frequency (Hz)', 'fontsize', 20);
ylabel('magnitude (1)', 'fontsize', 20);
title('Average Energy w.r.t. Central Frquency of Mel-Filterbank');
